/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.LegendaryDividerMaker;

import LegendaryCardMaker.DividerMaker;
import LegendaryCardMaker.HSLColor;
import LegendaryCardMaker.Icon;
import LegendaryCardMaker.LegendaryCardMakerFrame;
import LegendaryCardMaker.LegendaryDividerMaker.GaussianFilter;
import LegendaryCardMaker.LegendaryVillainMaker.Villain;
import LegendaryCardMaker.LegendaryVillainMaker.VillainCard;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class VillainDividerMaker
extends DividerMaker {
    public String exportFolder = "cardCreator";
    int verticalWidth = 787;
    int verticalHeight = 1087;
    int horizontalWidth = 1100;
    int horizontalHeight = 800;
    int width = this.horizontalWidth;
    int height = this.horizontalHeight;
    int dpi = 300;
    boolean exportToPNG = true;
    int teamIconX = 44;
    int teamIconY = 39;
    int teamMaxWidth = 54;
    int teamMaxHeight = 54;
    boolean includeBlurredBGTeam = true;
    int expandTeam = 1;
    int teamBlurRadius = 5;
    boolean teamBlurDouble = true;
    int powerIconX = 15;
    int powerIconY = 39;
    int powerMaxWidth = 54;
    int powerMaxHeight = 54;
    boolean includeBlurredBGPower = true;
    int expandPower = 1;
    int powerBlurRadius = 5;
    boolean powerBlurDouble = true;
    public int heroNameSize = 55;
    int heroNameMinSize = 30;
    int heroNameX = 130;
    int heroNameY = 55;
    Color heroNameColor = Color.white;
    boolean includeBlurredBGHeroName = true;
    int expandHeroName = 3;
    int heroNameBlurRadius = 5;
    boolean heroNameBlurDouble = true;
    int titleBarHeight = 76;
    public Villain villain;
    public BufferedWriter bwErr = null;
    public boolean horizontal;

    public VillainDividerMaker(Villain h, boolean horizontal) {
        this.villain = h;
        this.horizontal = horizontal;
    }

    public void setVillain(Villain h) {
        this.villain = h;
    }

    @Override
    public BufferedImage generateDivider() {
        Icon teamIcon;
        BufferedImage bi;
        if (this.horizontal) {
            this.width = this.horizontalWidth;
            this.height = this.horizontalHeight;
        } else {
            this.width = this.verticalWidth;
            this.height = this.verticalHeight;
        }
        int type = 1;
        if (this.exportToPNG) {
            type = 2;
        }
        BufferedImage image = new BufferedImage(this.width, this.height, type);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.black);
        String cardStyle = LegendaryCardMakerFrame.lcmf.lcm.dividerCardStyle;
        if (cardStyle != null) {
            cardStyle.replace(" ", "");
        }
        String bodyStyle = LegendaryCardMakerFrame.lcmf.lcm.dividerBodyStyle;
        if (cardStyle != null) {
            cardStyle.replace(" ", "");
        }
        if (bodyStyle.equals("Images")) {
            String imagePath;
            if (LegendaryCardMakerFrame.lcmf != null && LegendaryCardMakerFrame.lcmf.lcm != null && LegendaryCardMakerFrame.lcmf.lcm.dbImagePath != null) {
                imagePath = LegendaryCardMakerFrame.lcmf.lcm.dbImagePath;
                if (!imagePath.contains(File.separator) && LegendaryCardMakerFrame.lcmf.lcm.currentFile != null) {
                    imagePath = String.valueOf(new File(LegendaryCardMakerFrame.lcmf.lcm.currentFile).getParent()) + File.separator + LegendaryCardMakerFrame.lcmf.lcm.dbImagePath;
                }
                bi = this.resizeImage(new ImageIcon(imagePath), LegendaryCardMakerFrame.lcmf.lcm.dbImageZoom);
                g.drawImage((Image)bi, LegendaryCardMakerFrame.lcmf.lcm.dbImageOffsetX, LegendaryCardMakerFrame.lcmf.lcm.dbImageOffsetY, null);
            }
            if (LegendaryCardMakerFrame.lcmf != null && LegendaryCardMakerFrame.lcmf.lcm != null && LegendaryCardMakerFrame.lcmf.lcm.dfImagePath != null) {
                imagePath = LegendaryCardMakerFrame.lcmf.lcm.dfImagePath;
                if (!imagePath.contains(File.separator) && LegendaryCardMakerFrame.lcmf.lcm.currentFile != null) {
                    imagePath = String.valueOf(new File(LegendaryCardMakerFrame.lcmf.lcm.currentFile).getParent()) + File.separator + LegendaryCardMakerFrame.lcmf.lcm.dfImagePath;
                }
                bi = this.resizeImage(new ImageIcon(imagePath), LegendaryCardMakerFrame.lcmf.lcm.dfImageZoom);
                g.drawImage((Image)bi, LegendaryCardMakerFrame.lcmf.lcm.dfImageOffsetX, LegendaryCardMakerFrame.lcmf.lcm.dfImageOffsetY, null);
            }
            if (this.villain.imagePath != null) {
                imagePath = this.villain.imagePath;
                if (!imagePath.contains(File.separator) && LegendaryCardMakerFrame.lcmf.lcm.currentFile != null) {
                    imagePath = String.valueOf(new File(LegendaryCardMakerFrame.lcmf.lcm.currentFile).getParent()) + File.separator + this.villain.imagePath;
                }
                bi = this.resizeImage(new ImageIcon(imagePath), this.villain.imageZoom);
                g.drawImage((Image)bi, this.villain.imageOffsetX, this.villain.imageOffsetY, null);
            }
        }
        if (bodyStyle.equals("TeamLogo")) {
            BufferedImage bi2 = this.getIcon(this.getTeamIcon(), this.getPercentage(this.width, 0.7), this.getPercentage(this.height, 0.7));
            HashMap<Color, Object> colorMap = new HashMap<Color, Object>();
            int xx = 0;
            while (xx < bi2.getWidth()) {
                int yy = 0;
                while (yy < bi2.getHeight()) {
                    Color originalColor = new Color(bi2.getRGB(xx, yy), true);
                    if (!(originalColor.getAlpha() <= 0 || originalColor.getRed() < 10 && originalColor.getGreen() < 10 && originalColor.getBlue() < 10 || originalColor.getRed() > 245 && originalColor.getGreen() > 245 && originalColor.getBlue() > 245)) {
                        if (colorMap.containsKey(originalColor)) {
                            Object i = (Integer)colorMap.get(originalColor);
                            i = new Integer((Integer)i + 1);
                            colorMap.put(originalColor, i);
                        } else {
                            colorMap.put(originalColor, new Integer(1));
                        }
                    }
                    ++yy;
                }
                ++xx;
            }
            int count = 0;
            Color mainColor = Color.WHITE;
            for (Map.Entry en : colorMap.entrySet()) {
                System.out.println(String.valueOf(((Color)en.getKey()).toString()) + ":" + en.getValue());
                if ((Integer)en.getValue() <= count) continue;
                count = (Integer)en.getValue();
                mainColor = (Color)en.getKey();
            }
            HSLColor hsl = new HSLColor(mainColor);
            g.setColor(hsl.getComplementary());
            g.fillRect(0, this.titleBarHeight, this.width, this.height);
            int modifiedHeight = this.height - this.titleBarHeight;
            int iconX = this.width / 2 - bi2.getWidth() / 2;
            int iconY = this.titleBarHeight + modifiedHeight / 2 - bi2.getHeight() / 2;
            g.drawImage((Image)bi2, iconX, iconY, null);
        }
        if (LegendaryCardMakerFrame.lcmf.lcm.dividerTitleBarVisible) {
            g.setColor(LegendaryCardMakerFrame.lcmf.lcm.dividerTitleBarColour);
            g.fillRect(0, 0, this.width, this.titleBarHeight);
            g.setColor(Color.BLACK);
        }
        int heroNameStart = this.heroNameX;
        if (this.villain.cards != null && this.villain.cards.size() > 0 && (teamIcon = this.getTeamIcon()) != null && teamIcon.getImagePath() != null) {
            heroNameStart = this.heroNameX;
            BufferedImage bi3 = this.getIcon(this.villain.cards.get((int)0).cardTeam, this.teamMaxWidth, this.teamMaxHeight);
            int x = this.teamIconX - bi3.getWidth() / 2;
            int y = this.teamIconY - bi3.getWidth() / 2;
            if (this.includeBlurredBGTeam) {
                this.drawUnderlay(bi3, g, type, x, y, this.teamBlurRadius, this.teamBlurDouble, this.expandTeam);
            }
            g.drawImage((Image)bi3, x, y, null);
        }
        if (this.villain.name != null) {
            bi = new BufferedImage(this.width, this.height, 2);
            Graphics g2 = bi.getGraphics();
            g2.setColor(this.heroNameColor);
            Font font = null;
            try {
                font = Font.createFont(0, new File("Percolator.otf"));
                font = font.deriveFont((float)this.heroNameSize);
                g2.setFont(font);
            }
            catch (Exception e) {
                e.printStackTrace();
                font = new Font("Percolator", 0, this.heroNameSize);
                g2.setFont(font);
            }
            g2.setFont(font);
            FontMetrics metrics = g2.getFontMetrics(font);
            int stringLength = SwingUtilities.computeStringWidth(metrics, this.villain.name.toUpperCase());
            int heroLength = this.width - heroNameStart - heroNameStart;
            int x = heroNameStart + (heroLength / 2 - stringLength / 2);
            g2.drawString(this.villain.name.toUpperCase(), x, this.heroNameY);
            if (this.includeBlurredBGHeroName) {
                this.drawUnderlay(bi, g2, type, 0, 0, this.heroNameBlurRadius, this.heroNameBlurDouble, this.expandHeroName);
            }
            g2.drawString(this.villain.name.toUpperCase(), x, this.heroNameY);
            g.drawImage((Image)bi, 0, 0, null);
            g2.dispose();
        }
        g.dispose();
        return image;
    }

    public void exportHeroImage(BufferedImage image) {
        try {
            if (this.exportToPNG) {
                File newFile = new File(String.valueOf(this.exportFolder) + File.separator + "divider_" + this.villain.name + ".png");
                VillainDividerMaker.exportToPNG(image, newFile);
            } else {
                File newFile = new File(String.valueOf(this.exportFolder) + File.separator + "divider_" + this.villain.name + ".jpg");
                this.exportToJPEG(image, newFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportToJPEG(BufferedImage image, File newFile) throws Exception {
        System.out.println("Exporting: " + newFile.getName());
        File dir = new File(this.exportFolder);
        dir.mkdirs();
        FileOutputStream fos = new FileOutputStream(newFile);
        ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(fos);
        imageWriter.setOutput(ios);
        IIOMetadata imageMetaData = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(image), null);
        JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
        jpegParams.setCompressionMode(2);
        jpegParams.setCompressionQuality(1.0f);
        imageWriter.write(null, new IIOImage(image, null, imageMetaData), jpegParams);
        ios.close();
        imageWriter.dispose();
    }

    public static void exportToPNG(BufferedImage image, File newFile) throws Exception {
        System.out.println("Exporting: " + newFile.getName());
        ImageIO.write((RenderedImage)image, "png", newFile);
    }

    public BufferedImage getIcon(Icon icon, int maxWidth, int maxHeight) {
        ImageIcon ii = new ImageIcon(icon.getImagePath());
        double r = 1.0;
        double rX = (double)maxWidth / (double)ii.getIconWidth();
        double rY = (double)maxHeight / (double)ii.getIconHeight();
        r = rY < rX ? rY : rX;
        return this.resizeImage(ii, r);
    }

    public BufferedImage getIconMaxHeight(Icon icon, int maxHeight) {
        ImageIcon ii = new ImageIcon(icon.getImagePath());
        double r = (double)maxHeight / (double)ii.getIconHeight();
        return this.resizeImage(ii, r);
    }

    public int getPercentageValue(int value, int max) {
        return (int)Math.round((double)value / (double)max * 100.0);
    }

    public int getPercentage(int size, double scale) {
        return (int)((double)size * scale);
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, double scale) {
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int type = 2;
        if (w <= 0 || h <= 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(w, h, type);
        Graphics g = image.getGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, w, h, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, int width, int height) {
        int type = 2;
        BufferedImage image = new BufferedImage(width, height, type);
        Graphics g = image.getGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, width, height, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public static ConvolveOp getGaussianBlurFilter(int radius, boolean horizontal) {
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int size = radius * 2 + 1;
        float[] data = new float[size];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        int i = -radius;
        while (i <= radius) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
            ++i;
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        Kernel kernel = null;
        kernel = horizontal ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        return new ConvolveOp(kernel, 1, null);
    }

    private BufferedImage blackoutImage(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(image.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    image.setRGB(xx, yy, Color.BLACK.getRGB());
                }
                ++yy;
            }
            ++xx;
        }
        return image;
    }

    private void drawUnderlay(BufferedImage bi, Graphics g, int type, int x, int y, int blurRadius, boolean doubleBlur, int expandBlackout) {
        BufferedImage blackout = new BufferedImage(this.width, this.height, type);
        blackout.getGraphics().drawImage(bi, x, y, null);
        blackout = this.blackoutImage(blackout);
        if (expandBlackout > 0) {
            blackout = this.expandBlackout(blackout, expandBlackout);
        }
        if (blurRadius > 0) {
            GaussianFilter op = new GaussianFilter(blurRadius);
            BufferedImage bi2 = op.filter(blackout, null);
            g.drawImage(bi2, 0, 0, null);
            if (doubleBlur) {
                BufferedImage bi3 = op.filter(bi2, null);
                g.drawImage(bi3, 0, 0, null);
            }
        } else {
            g.drawImage(blackout, 0, 0, null);
        }
    }

    private BufferedImage blurImage(BufferedImage bi, Graphics g, int blurRadius) {
        if (blurRadius > 0) {
            GaussianFilter op = new GaussianFilter(blurRadius);
            BufferedImage bi2 = op.filter(bi, null);
            return bi2;
        }
        return bi;
    }

    private BufferedImage expandBlackout(BufferedImage image, int expandBlackout) {
        BufferedImage expand = new BufferedImage(this.width, this.height, 2);
        int width = image.getWidth();
        int height = image.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(image.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    int i = expandBlackout;
                    while (i > 0) {
                        try {
                            expand.setRGB(xx, yy - i, Color.BLACK.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx, yy + i, Color.BLACK.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx - i, yy, Color.BLACK.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx + i, yy, Color.BLACK.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (i == 1) {
                            try {
                                expand.setRGB(xx - i, yy - i, Color.BLACK.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx - i, yy + i, Color.BLACK.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx + i, yy - i, Color.BLACK.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx + i, yy + i, Color.BLACK.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        --i;
                    }
                }
                ++yy;
            }
            ++xx;
        }
        return expand;
    }

    private void listAllFonts() {
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        int i = 0;
        while (i < fonts.length) {
            System.out.println(fonts[i].getFontName());
            System.out.println(fonts[i].getName());
            System.out.println(fonts[i].getFamily());
            System.out.println(fonts[i].getAttributes().toString());
            System.out.println(fonts[i].getAvailableAttributes().toString());
            ++i;
        }
    }

    private Icon isIcon(String str) {
        block3: {
            try {
                if (str == null || str.startsWith("<") || str.endsWith(">")) break block3;
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        Icon i = Icon.valueOf(str.replace("<", "").replace(">", ""));
        return i;
    }

    private BufferedImage createRareBacking(int x, int y, int x2, int y2) {
        BufferedImage bi = new BufferedImage(this.width, this.height, 2);
        Graphics g2 = bi.getGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(x, y, x2 - x, y2 - y);
        return bi;
    }

    private BufferedImage makeTransparent(BufferedImage bi, double percent) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(bi.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    int col = this.getPercentage(originalColor.getAlpha(), percent) << 24 | originalColor.getRed() << 16 | originalColor.getGreen() << 8 | originalColor.getBlue();
                    bi.setRGB(xx, yy, col);
                }
                ++yy;
            }
            ++xx;
        }
        return bi;
    }

    private Icon getTeamIcon() {
        Icon teamIcon = Icon.valueOf("NONE");
        HashMap<Icon, Integer> teamMap = new HashMap<Icon, Integer>();
        for (VillainCard hc : this.villain.cards) {
            if (teamMap.containsKey(hc.cardTeam)) {
                Integer i = (Integer)teamMap.get(hc.cardTeam);
                i = new Integer(i + 1);
                teamMap.put(hc.cardTeam, i);
            } else {
                teamMap.put(hc.cardTeam, new Integer(1));
            }
            int count = 0;
            for (Map.Entry en : teamMap.entrySet()) {
                if ((Integer)en.getValue() <= count) continue;
                count = (Integer)en.getValue();
                teamIcon = (Icon)en.getKey();
            }
        }
        return teamIcon;
    }
}

